<?php

if (isset($_GET['bin'])) {
    // Ambil dan bersihkan input, hanya 6 digit angka
    $bin = $_GET['bin'];
    $cardBIN = substr(preg_replace('/\D/', '', $bin), 0, 6);

    // Cek panjang BIN
    if (strlen($cardBIN) < 6) {
        http_response_code(400);
        echo json_encode(['error' => 'BIN harus minimal 6 digit angka.']);
        exit;
    }

    // URL API
    $url = "https://data.handyapi.com/bin/" . $cardBIN;

    // Inisialisasi cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // Jika perlu API key: sesuaikan baris berikut
    // curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer YOUR_API_KEY']);

    // Eksekusi request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Tangani error cURL
    if (curl_errno($ch)) {
        http_response_code(500);
        echo json_encode(['error' => 'cURL Error: ' . curl_error($ch)]);
        curl_close($ch);
        exit;
    }

    curl_close($ch);

    // Tangani error HTTP
    if ($httpCode !== 200) {
        http_response_code($httpCode);
        echo json_encode(['error' => 'Gagal mengambil data dari API. HTTP Code: ' . $httpCode]);
        exit;
    }

    // Ubah ke array PHP dari JSON
    $data = json_decode($response, true);

    if (is_array($data)) {
        header('Content-Type: application/json');
        echo json_encode($data, JSON_PRETTY_PRINT);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Gagal mengurai response JSON.']);
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Parameter BIN tidak ditemukan.']);
}
