<?php
$ip = $_SERVER['REMOTE_ADDR'];
$log_file = 'log_ip.txt';

$apiUrl = 'http://ip-api.com/json/' . urlencode($ip);
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo 'Error saat melakukan request: ' . curl_error($ch);
} else {
    print_r($response);

    $data = json_decode($response, true);
    if ($data && isset($data['status']) && $data['status'] === 'success') {
        $country = $data['country'] ?? 'Unknown';
        $region  = $data['regionName'] ?? 'Unknown';
        $city    = $data['city'] ?? 'Unknown';

        $log_line = sprintf(
            "%s - %s - %s, %s, %s",
            date('Y-m-d H:i:s'),
            $ip,
            $city,
            $region,
            $country
        );

        file_put_contents($log_file, $log_line . PHP_EOL, FILE_APPEND);
    }
}

curl_close($ch);
?>
